<?php
/*============================================================================*\
|| ########################################################################## ||
|| # vB4 Trading Platform Functions                                         # ||
|| # ---------------------------------------------------------------------- # ||
|| # 2012-02-19 Set thread image to first or random attached picture        # ||
|| # ---------------------------------------------------------------------- # ||
|| # (C) Copyright Y2K Software s.a.s. 2012 - All Rights Reserved.          # ||
|| # This file may not be redistributed in whole or significant part.       # ||
|| ########################################################################## ||
\*============================================================================*/

/**
 * @author Y2K Software
 * @copyright (C) Copyright Y2K Software 2012 - All Rights Reserved
 * @version 1.0.3
 * @link www.pagerobot.com
 */

/**
 * vtp_set_thread_icon()
 * 
 * Set thread image to first or random attached picture, or to a default image.
 * 
 * @see http://www.vbulletin.it/content/198-Mercatino-Parte-9
 * 
 * @param mixed $thread
 * @param bool $showrandom
 * @return void
 */
function vtp_set_thread_icon(&$thread, $showrandom = false)
{
    global $vbulletin;
    
    $ordersql = 'ORDER BY ' . ($showrandom ? 'RAND()' : 'attachmentid');

    $thread['threadiconpath'] = 'images/misc/vtp_nophoto.png'; 
    if(!$thread['attach'])
    {
        // Ignore threads with no attachments
    	return;
    }

    //print_r($thread); die;

    $SQL = "SELECT attachmentid, dateline 
        FROM " . TABLE_PREFIX . "attachment 
        WHERE contenttypeid=1
            AND contentid=$thread[firstpostid]
            AND state='visible' 
            AND (filename LIKE '%.gif' OR filename LIKE '%.jpg' OR filename LIKE '%.png' OR filename LIKE '%.jpeg') 
        $ordersql 
        LIMIT 1";
    if($rs = $vbulletin->db->query_first($SQL))
    {
        $thread['threadiconpath'] = "attachment.php?attachmentid=$rs[attachmentid]&d=$rs[dateline]&thumb=1"; 
    }
}

